document.addEventListener('DOMContentLoaded', function() {

// Variables 

var header = document.getElementById("header");
var menuMobile = document.getElementById("menu__mobile");
var menu = document.getElementById("menu");
var testimonialsContainer = document.getElementsByClassName("testimonials__container")[0];
var testimonialsItem = document.getElementsByClassName("testimonials__item");
var testimonialsPrev = document.getElementsByClassName("testimonials__prev")[0];
var testimonialsNext = document.getElementsByClassName("testimonials__next")[0];
var testimonialsCurrent = 0;
var testimonialsContent = "";
var dateDepart = document.getElementById('date_depart');
var dateRetour = document.getElementById('date_retour');

// Data 

var testimonials = ["Simple et facile d'utilisation. Ce site est génial, les voitures sont bien entrenues et les employés sont aimable et poli. Je recommande ce site pour votre porchaine location si vous voulez avoir une belle voiture de luxe ou de collection", 
"Je suis ravie de mon expérience avec LuxeLivery! J'ai loué une magnifique Mustang des années 60 pour un événement spécial et tout s'est déroulé à merveille. La voiture était en parfait état, et le service client était exceptionnel, toujours prêt à répondre à mes questions. Je recommande vivement ce site à tous les passionnés de voitures de collection", 
"Excellente expérience. J'ai loué une Ferrari pour un week-end et c'était incroyable. La voiture était impeccable, et le processus de location était simple et rapide. Le personnel est très professionnel et attentif. Une expérience à renouveler sans hésitation !", 
"J'ai récemment loué une Jaguar des années 70 et je suis absolument satisfaite. La voiture était en excellent état et a ajouté une touche d'élégance à notre mariage. Le service était courtois et efficace, et ils ont même arrangé la livraison directement à notre lieu de réception. Merci pour cette belle expérience !", 
"Louer une Lamborghini chez LuxeLivery a été une expérience extraordinaire. La voiture était un véritable bijou, et la procédure de location était très fluide. Le personnel a fait preuve de beaucoup de professionnalisme et a su rendre ce moment unique. Je recommande vivement ce service à tous ceux qui veulent vivre une expérience de conduite hors du commun"];
var testimonialsAuthors = ["Caroline Lemarchand", "Julie Martin", "Pierre Dupont", "Sophie Bernard", "Marc Leroy"];
var testimonialsImages = ["avatar.jpg", "avatar.jpg", "avatar.jpg", "avatar.jpg", "avatar.jpg"];

// Fonctions

function changeHeader() {
    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
        header.classList.add("header__scroll");
    } 
    else {
        header.classList.remove("header__scroll");
    }
}

function openMenu() {
    menuMobile.classList.toggle("menu__mobile__close");
    menu.classList.toggle("menu__open");
}

function changeTestimonialsPrev() {
    testimonialsCurrent = testimonialsCurrent - 1;
    if (testimonialsCurrent < 0) {
        testimonialsCurrent = testimonialsItem.length - 1;
    }
    testimonialsContainer.style.transform = "translateX(" + -100 * testimonialsCurrent + "%)";
}

function changeTestimonialsNext() {
    testimonialsCurrent = testimonialsCurrent + 1;
    if (testimonialsCurrent >= testimonialsItem.length) {
        testimonialsCurrent = 0;
    }
    testimonialsContainer.style.transform = "translateX(" + -100 * testimonialsCurrent + "%)";
}

function initTestimonials() {
    for (var i = 0; i < testimonials.length; i++) { 
        testimonialsContent = testimonialsContent + '<div class="testimonials__item">' 
        + "<p>" + testimonials[i] + "</p>" + '<div class="testimonials__author">' 
        + '<div><img class="testimonials__picture" src="img/' + testimonialsImages[i] + '" alt="Auteur"></div>'
        + '<div><p>' + testimonialsAuthors[i] + '</p><img class="testimonials__stars" src="img/etoiles.png" alt="5 étoiles"></div>'
        + '</div>'
        + '</div>';
    } 
    testimonialsContainer.innerHTML = testimonialsContent;
}

function initSearch() {
    var today = new Date();
    dateDepart.valueAsDate = today;
    dateDepart.setAttribute("min", today.toISOString().split('T')[0]);
    
    var tomorrow = new Date();
    tomorrow.setDate(today.getDate() + 1);
    dateRetour.valueAsDate = tomorrow;
    dateRetour.setAttribute("min", tomorrow.toISOString().split('T')[0]);
}

function changeSearchReturnDate() {
    console.log("yo");
    if (dateRetour.valueAsDate <= dateDepart.valueAsDate) {
        var newDate = new Date(dateDepart.valueAsDate);
        newDate.setDate(newDate.getDate() + 1);
        dateRetour.valueAsDate = newDate;
    }
    var minReturnDate = new Date(dateDepart.valueAsDate);
    minReturnDate.setDate(minReturnDate.getDate() + 1);
    dateRetour.setAttribute("min", minReturnDate.toISOString().split('T')[0]);
}

// Evenements 

document.addEventListener("scroll", changeHeader);
menuMobile.addEventListener("click", openMenu);
testimonialsPrev.addEventListener("click", changeTestimonialsPrev);
testimonialsNext.addEventListener("click", changeTestimonialsNext);
initTestimonials();
setInterval(changeTestimonialsNext, 5000);
initSearch();
dateDepart.addEventListener("change", changeSearchReturnDate);

}, false);

